/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.level.system;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import team.creative.creativecore.common.level.CreativeLevel;
import team.creative.creativecore.common.level.listener.LevelBoundsListener;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.list.SingletonList;

public class BlockUpdateLevelSystem {
    public final CreativeLevel level;
    private final List<LevelBoundsListener> levelBoundListeners = new ArrayList<LevelBoundsListener>();
    private int boundMinX = Integer.MAX_VALUE;
    private int boundMinY = Integer.MAX_VALUE;
    private int boundMinZ = Integer.MAX_VALUE;
    private int boundMaxX = Integer.MIN_VALUE;
    private int boundMaxY = Integer.MIN_VALUE;
    private int boundMaxZ = Integer.MIN_VALUE;
    private HashSet<class_2338> edgePositions = new HashSet();
    private HashSet<class_2338> allBlocks = new HashSet();

    public BlockUpdateLevelSystem(CreativeLevel level) {
        this.level = level;
    }

    public void registerLevelBoundListener(LevelBoundsListener listener) {
        this.levelBoundListeners.add(listener);
    }

    public Iterable<LevelBoundsListener> levelBoundListeners() {
        return this.levelBoundListeners;
    }

    private int getBound(Facing facing) {
        return switch (facing) {
            case Facing.EAST -> this.boundMaxX;
            case Facing.WEST -> this.boundMinX;
            case Facing.UP -> this.boundMaxY;
            case Facing.DOWN -> this.boundMinY;
            case Facing.SOUTH -> this.boundMaxZ;
            case Facing.NORTH -> this.boundMinZ;
            default -> throw new UnsupportedOperationException();
        };
    }

    private void setBound(Facing facing, int value) {
        switch (facing) {
            case EAST: {
                this.boundMaxX = value;
                break;
            }
            case WEST: {
                this.boundMinX = value;
                break;
            }
            case UP: {
                this.boundMaxY = value;
                break;
            }
            case DOWN: {
                this.boundMinY = value;
                break;
            }
            case SOUTH: {
                this.boundMaxZ = value;
                break;
            }
            case NORTH: {
                this.boundMinZ = value;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected boolean isWithinBoundsNoEdge(class_2338 pos) {
        return this.boundMinX < pos.method_10263() && this.boundMaxX > pos.method_10263() && this.boundMinY < pos.method_10264() && this.boundMaxY > pos.method_10264() && this.boundMinZ < pos.method_10260() && this.boundMaxZ > pos.method_10260();
    }

    protected boolean isWithinBounds(class_2338 pos) {
        return this.boundMinX <= pos.method_10263() && this.boundMaxX >= pos.method_10263() && this.boundMinY <= pos.method_10264() && this.boundMaxY >= pos.method_10264() && this.boundMinZ <= pos.method_10260() && this.boundMaxZ >= pos.method_10260();
    }

    private boolean isEdgeExcept(class_2338 pos, Facing facing) {
        for (int i = 0; i < Facing.values().length; ++i) {
            Facing other = Facing.values()[i];
            if (other == facing || pos.method_30558(other.axis.toVanilla()) != this.getBound(other)) continue;
            return true;
        }
        return false;
    }

    public void init(Iterable<class_2338> positions) {
        this.boundMinX = Integer.MAX_VALUE;
        this.boundMinY = Integer.MAX_VALUE;
        this.boundMinZ = Integer.MAX_VALUE;
        this.boundMaxX = Integer.MIN_VALUE;
        this.boundMaxY = Integer.MIN_VALUE;
        this.boundMaxZ = Integer.MIN_VALUE;
        for (class_2338 pos : positions) {
            this.boundMinX = Math.min(this.boundMinX, pos.method_10263());
            this.boundMinY = Math.min(this.boundMinY, pos.method_10264());
            this.boundMinZ = Math.min(this.boundMinZ, pos.method_10260());
            this.boundMaxX = Math.max(this.boundMaxX, pos.method_10263());
            this.boundMaxY = Math.max(this.boundMaxY, pos.method_10264());
            this.boundMaxZ = Math.max(this.boundMaxZ, pos.method_10260());
            this.allBlocks.add(pos);
        }
        for (class_2338 pos : this.allBlocks) {
            if (pos.method_10263() != this.boundMinX && pos.method_10263() != this.boundMaxX && pos.method_10264() != this.boundMinY && pos.method_10264() != this.boundMaxY && pos.method_10260() != this.boundMinZ && pos.method_10260() != this.boundMaxZ) continue;
            this.edgePositions.add(pos);
        }
        this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, this.edgePositions));
    }

    public void blockChanged(class_2338 pos) {
        block10: {
            block9: {
                class_2680 state = this.level.method_8320(pos);
                if (!state.method_26215()) break block9;
                if (!this.allBlocks.remove(pos) || !this.edgePositions.remove(pos)) break block10;
                for (int i = 0; i < Facing.values().length; ++i) {
                    Facing facing = Facing.values()[i];
                    class_2350.class_2351 axis = facing.axis.toVanilla();
                    int bound = this.getBound(facing);
                    if (bound != pos.method_30558(axis)) continue;
                    ArrayList<class_2338> remaining = new ArrayList<class_2338>();
                    for (class_2338 class_23382 : this.edgePositions) {
                        if (class_23382.method_30558(axis) != bound) continue;
                        remaining.add(class_23382);
                    }
                    if (remaining.isEmpty()) {
                        int newBound = facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                        for (class_2338 scan : this.allBlocks) {
                            newBound = facing.positive ? Math.max(newBound, scan.method_30558(axis)) : Math.min(newBound, scan.method_30558(axis));
                        }
                        for (class_2338 scan : this.allBlocks) {
                            if (scan.method_30558(axis) != newBound) continue;
                            remaining.add(scan);
                            this.edgePositions.add(scan);
                        }
                        this.setBound(facing, newBound);
                    }
                    this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, facing, remaining, facing.positive ? bound + 1 : bound));
                }
                break block10;
            }
            if (this.allBlocks.add(pos) && !this.isWithinBoundsNoEdge(pos)) {
                for (int i = 0; i < Facing.values().length; ++i) {
                    Facing facing = Facing.values()[i];
                    class_2350.class_2351 axis = facing.axis.toVanilla();
                    int bound = this.getBound(facing);
                    if (bound == pos.method_30558(axis)) {
                        ArrayList<class_2338> remaining = new ArrayList<class_2338>();
                        this.edgePositions.add(pos);
                        for (class_2338 class_23383 : this.edgePositions) {
                            if (class_23383.method_30558(axis) != bound) continue;
                            remaining.add(class_23383);
                        }
                        this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, facing, remaining, facing.positive ? bound + 1 : bound));
                        continue;
                    }
                    if (bound <= pos.method_30558(axis)) continue;
                    this.edgePositions.removeIf(edge -> edge.method_30558(axis) == bound && !this.isEdgeExcept((class_2338)edge, facing));
                    this.edgePositions.add(pos);
                    this.levelBoundListeners.forEach(x -> x.rescan(this.level, this, facing, new SingletonList<class_2338>(pos), facing.positive ? bound + 1 : bound));
                }
            }
        }
    }
}

